\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{PELsmallreport}[26/09/2018 Small reports class for EE-365 course]
\LoadClass[10pt,oneside,a4paper]{article}

\RequirePackage[hmargin={1.5cm,1.5cm},vmargin={1.5cm,1.5cm},footskip=.8cm,includefoot,heightrounded]{geometry}
\setlength\parindent{0pt}

\RequirePackage[fleqn]{amsmath}
\RequirePackage{mathtools}
\RequirePackage{physics}
\RequirePackage{nicefrac}
\RequirePackage{pgfplotstable}
\RequirePackage{booktabs}
\newcommand{\tabitem}{~~\llap{\textbullet}~~}
\RequirePackage{hhline}
\RequirePackage{tabularx,amsmath,stackengine}
\RequirePackage{tablefootnote}

\RequirePackage{mathspec} % implies xelatex!
\setmainfont[BoldFont=RobotoCondensed-Regular, ItalicFont=RobotoCondensed-LightItalic, Ligatures=TeX]{RobotoCondensed-Light}
%\setmonofont[]{RobotoMono-Bold.ttf}
\setmathfont(Greek,Digits,Latin){RobotoCondensed-Light}
\setmathrm[ItalicFont=RobotoCondensed-LightItalic, BoldFont=RobotoCondensed-Regular]{RobotoCondensed-Light}
\RequirePackage[normalweight=Light]{mdsymbol}

\RequirePackage{polyglossia}
\setmainlanguage[variant=british]{english}

\renewcommand{\arraystretch}{1.2}
\RequirePackage{multirow}
\RequirePackage{colortbl}

\RequirePackage{tikz}
\RequirePackage{pgfplots}
\pgfplotsset{compat=newest}
\pgfplotsset{plot coordinates/math parser=false}
\pgfplotsset{
 every axis/.append style={
   xlabel style={font=\scriptsize},
   ylabel style={font=\scriptsize,align=center},
   yticklabel style = {font=\scriptsize},
   xticklabel style = {font=\scriptsize},
   legend style = {font=\scriptsize},
   title style = {font=\scriptsize,yshift=-6pt},
 },
  every axis plot/.append style={line width=0.75pt},
 }
 \tikzset{
  every node/.style = {font=\small},
 }
\newlength{\figurewidth}
\newlength{\figureheight}
\usepgfplotslibrary{colorbrewer}
\pgfplotsset{cycle list/Dark2-8}

\RequirePackage{xcolor}
% EPFL colors
\definecolor{redlogo}{HTML}{E2001A}
\definecolor{redb}{HTML}{AE0010}
\definecolor{redm}{HTML}{7E000C}
\definecolor{redd}{HTML}{5D0009}
\definecolor{orangeb}{HTML}{EA5E00}
\definecolor{orangem}{HTML}{D53C00}
\definecolor{oranged}{HTML}{B91E00}
\definecolor{blueb}{HTML}{007BA5}
\definecolor{bluem}{HTML}{015876}
\definecolor{blued}{HTML}{003047}
\definecolor{violetb}{HTML}{8972D5}
\definecolor{violetm}{HTML}{5D41A2}
\definecolor{violetd}{HTML}{431F7F}
\definecolor{turquoiseb}{HTML}{1BB5B5}
\definecolor{turquoisem}{HTML}{007F87}
\definecolor{turquoised}{HTML}{004D59}
\definecolor{greenb}{HTML}{6FBA01}
\definecolor{greenm}{HTML}{439809}
\definecolor{greend}{HTML}{0B7101}
\definecolor{burgundyb}{HTML}{990165}
\definecolor{burgundym}{HTML}{740052}
\definecolor{burgundyd}{HTML}{5D0048}
\definecolor{yellowb}{HTML}{DAA521}
\definecolor{yellowm}{HTML}{B77504}
\definecolor{yellowd}{HTML}{A25700}
\definecolor{brownb}{HTML}{895116}
\definecolor{brownm}{HTML}{652F00}
\definecolor{brownd}{HTML}{471900}
\definecolor{grayb}{HTML}{999C98}
\definecolor{graym}{HTML}{696F6E}
\definecolor{grayd}{HTML}{474E52}

\RequirePackage{hyperref}
\RequirePackage{cleveref}

\RequirePackage{pdfpages}

\RequirePackage{siunitx}

%Nikolinas Specials
\RequirePackage[title]{appendix}
\RequirePackage{tabu}
\RequirePackage{pdflscape}
\RequirePackage{longtable}
\RequirePackage{framed}
\RequirePackage[export]{adjustbox}
\RequirePackage{gensymb}

\DeclareSIUnit\year{yr}
\DeclareSIUnit{\percent}{\text{\%}}
\sisetup{range-phrase=-, range-units=single}

\RequirePackage{calc}
\RequirePackage{xfrac}

\RequirePackage{graphicx}
\RequirePackage{float}

\RequirePackage[perpage,bottom]{footmisc}

\RequirePackage{csquotes}
\RequirePackage[style=ieee, backend=biber, isbn=false, clearlang=false, maxbibnames=10, mincitenames=1, maxcitenames=2]{biblatex}
\defbibheading{bibliography}[\refname]{\section*{#1}}
\AtNextBibliography{\small}

% colon behind author in bibliography
\renewcommand{\labelnamepunct}{\addcolon\space}

\RequirePackage{xpatch}
% author in bold font in bibliography
\xpretobibmacro{author}{\mkbibbold\bgroup}{}{}
\xapptobibmacro{author}{\egroup}{}{}
\xpretobibmacro{bbx:shortauthor}{\mkbibbold\bgroup}{}{}
\xapptobibmacro{bbx:shortauthor}{\egroup}{}{}
\xpretobibmacro{bbx:editor}{\mkbibbold\bgroup}{}{}
\xapptobibmacro{bbx:editor}{\egroup}{}{}

\DeclareFieldFormat{sentencecase}{\bbx@colon@search\MakeSentenceCase{#1}}
\DeclareFieldFormat*{citetitle}{#1}
\DeclareFieldFormat*{journaltitle}{#1}
\DeclareFieldFormat*{issuetitle}{#1}
\DeclareFieldFormat*{maintitle}{#1}
\DeclareFieldFormat*{booktitle}{#1}
\DeclareFieldFormat*{title}{#1}

\RequirePackage{url}
\urlstyle{same}

\RequirePackage{listings}
\lstset{language=C, basicstyle=\ttfamily\footnotesize, breaklines=true, keywordstyle=\color{blue}, stringstyle=\color{red}, commentstyle=\color{green}, morecomment=[l][\color{orange}]{\#}, frame=l}

%Figure captions
\RequirePackage{caption}
\captionsetup[table]{justification=justified,singlelinecheck=false,labelfont={bf},font=small,labelsep=quad,position=top}
\captionsetup[figure]{justification=justified,singlelinecheck=false,labelfont={bf},font=small,aboveskip=5pt,labelsep=quad}
\captionsetup[lstlisting]{justification=justified,singlelinecheck=false,labelfont={bf},font=small,aboveskip=5pt,labelsep=quad}
\RequirePackage[caption=false,font=footnotesize,labelfont=rm,singlelinecheck=true]{subfig}

% Fix names
\addto\captionsenglish{%
  \renewcommand{\contentsname}{Table of Contents}%
}

% Fix \MakeUppercase
\RequirePackage{makerobust}
\MakeRobustCommand\@hangfrom
\newcommand*{\ModMakeUppercase}{%
  \MakeRobustCommand\@svsec
  \MakeUppercase
}

\RequirePackage[pagestyles,explicit]{titlesec}
\titleformat{\section}
  {\Large\bfseries}{\thesection}{1em}{\MakeUppercase{#1}}

\RequirePackage{textgreek} % Jules

%Higher levels of sectioning available
% \RequirePackage{titlesec}
\setcounter{secnumdepth}{0}
% \setcounter{tocdepth}{4}

\titleformat{\subsection}
  {\large\bfseries}{\thesubsection}{1em}{\MakeUppercase{#1}}

\titleformat{\subsubsection}
  {\normalsize\bfseries}{\thesubsubsection}{1em}{\MakeUppercase{#1}}

\renewpagestyle{plain}{
  \setfoot[\thepage][][]{}{}{\thepage}
  \sethead[][][]{}{}{}
  %\sethead[\bfseries\normalsize\thepage\quad\dg@bartwo\quad\leftmark][][]{}{}{\rightmark\quad\dg@bartwo\quad\bfseries\normalsize\thepage}
}
\pagestyle{plain}

% Fix itemize
\RequirePackage{enumitem}
\setlist{nolistsep,topsep=-\parskip}
% \setlist[itemize,1]{label=$\bullet$}
% \setlist[itemize,2]{label=$\circ$}
% \setlist[itemize,3]{label=$\cdot$}
\setlist[description]{font=\MakeUppercase}

\RequirePackage{array}
\newcolumntype{C}[1]{>{\centering\arraybackslash}p{#1}} % column with specified width (like p), but with centered text

% Custom title
\renewcommand{\@maketitle}{\par
  \noindent\begin{minipage}[t]{\textwidth}
    \begin{tabular}{
      |p{.3\textwidth-2\arrayrulewidth-2\tabcolsep}|
       p{.44\textwidth-\arrayrulewidth-2\tabcolsep}|
       p{.26\textwidth-\arrayrulewidth-2\tabcolsep}|
    }
      \hline
      \scriptsize\textit{Type of Document} & \scriptsize\textit{Document ID} &  \scriptsize\textit{Status}\\
      {\setType} & {\setID} & {\setStatus}\\ \hline
      \multicolumn{1}{|c|}{\multirow{6}{*}{\includegraphics[height=4.8\normalbaselineskip,keepaspectratio]{gfx/PEL.pdf}}} & \scriptsize\textit{Author(s) Name(s)} & \scriptsize\textit{Function}\\
      & {\setAuthor} & \setFunction\\
      & {\setAuthorTwo} & \\
      & \scriptsize\textit{Assistant Name} & \scriptsize\textit{Date of Submission}\\
      & {\setAssistantOne} &\setDeadline\\
      & {\setAssistantTwo} &  \\ \hline
      \multicolumn{3}{|l|}{\scriptsize\textit{Title}}\\
      \multicolumn{3}{|C{\textwidth-2\arrayrulewidth-2\tabcolsep}|}{\LARGE\bfseries\MakeUppercase{\setTitle}}\\ \hline
      \multicolumn{3}{|l|}{\scriptsize\textit{Course Name}}\\
      \multicolumn{3}{|l|}{\setCourseName}\\ \hline
      \multicolumn{3}{|l|}{\scriptsize\textit{Keywords}}\\
      \multicolumn{3}{|l|}{\setKeywords}\\ \hline
    \end{tabular}
  \end{minipage}
}

\AtBeginDocument{\maketitle\thispagestyle{plain}}

\newcommand\setType[1]{\def\setType{#1}}
\newcommand\setID[1]{\def\setID{#1}}
\newcommand\setStatus[1]{\def\setStatus{#1}}
\newcommand\setAuthor[1]{\def\setAuthor{#1}}
\newcommand\setAuthorTwo[1]{\def\setAuthorTwo{#1}}
\newcommand\setFunction[1]{\def\setFunction{#1}}
\newcommand\setAssistantOne[1]{\def\setAssistantOne{#1}}
\newcommand\setAssistantTwo[1]{\def\setAssistantTwo{#1}}
\newcommand\setDeadline[1]{\def\setDeadline{#1}}
\newcommand\setTitle[1]{\def\setTitle{#1}}
\newcommand\setCourseName[1]{\def\setCourseName{#1}}
\newcommand\setKeywords[1]{\def\setKeywords{#1}}

% \setFunction{MSc Student(s)}
% \setType{Technical Report}
% \setID{EPFL-PEL -- EE-565 Report 1}
% \setClassification{Top Secret}
% \setStatus{Final Report}
% \setAssistant{\href{mailto:jules.mace@epfl.ch}{Jules Macé}}
% \setAssistantTwo{\href{mailto:yanick.frei@epfl.ch}{Yanick Frei}}
% \setDeadline{13.03.2023, 23:59}
% \setTitle{Report No. 1 - DC Machine Modeling and Control}
% \setCourseName{EE-565 Industrial Electronics II}
% \setKeywords{DC Machine Modeling and Control}

\setFunction{MSc Student(s)}
\setType{Course Report}
\setID{EPFL-PEL -- EE-565 Report 1}
\setStatus{Final report}
\setAssistantOne{\href{mailto:gaia.petrillo@epfl.ch}{Gaia Petrillo}}
%\setAssistantTwo{\href{mailto:yanick.frei@epfl.ch}{Yanick Frei}}
\setAssistantTwo{\href{mailto:israel.yepezlopez@epfl.ch}{Israel Yepez Lopez}}
\setDeadline{05.05.2025, 23:59}
\setTitle{Report No. 2 - Induction Machine Modeling and Scalar Control}
\setCourseName{EE-565 Industrial Electronics II}
\setKeywords{Induction Machine Modeling and Sacalar controlControl}